


varying vec4 projCoord;
varying vec3 normal;
	
	void main()
	{	
  	gl_TexCoord[0] = gl_MultiTexCoord0;
	normal = normalize(gl_NormalMatrix * gl_Normal);	


	vec4 realPos = gl_ModelViewMatrix * gl_Vertex;
  
	projCoord = gl_TextureMatrix[1] * realPos;
	gl_FrontColor = gl_Color;

	vec3 u = normalize( vec3(gl_ModelViewMatrix * gl_Vertex) );
	vec3 n = normalize( gl_NormalMatrix * gl_Normal );
	vec3 r = reflect( u, n );
	float m = 2.0 * sqrt( r.x*r.x + r.y*r.y + (r.z+1.0)*(r.z+1.0) );
	gl_TexCoord[2].s = r.x/m + 0.5;
	gl_TexCoord[2].t = r.y/m + 0.5;

	gl_Position = ftransform();
	} 